/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.kintai.dto.CmRotationDto;

public class ScheduleRotationListVo extends ScheduleMenuVo {

	private static final long serialVersionUID = -2955682777312003130L;

	// URLACSS
	private static final String RETURN_URL = "/jsp/kintai/scheduleRotationList.jsp";
	private static final String EXTRA_JS   = "/pub/kintai/js/scheduleRotationList.js";
	private static final String EXTRA_CSS  = "/pub/kintai/css/scheduleRotationList.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_SCHEDULE_ROTATION_MASTER;

	//萔
	public static final int SEARCH_OFF = 0;
	public static final int SEARCH_ON  = 1;

	//p[^
	public static final String PRM_TXT_RT_CODE		= "txtRtCode";
	public static final String PRM_TXT_RT_NAME		= "txtRtName";

	//tB[h
	private String[]	aryRTCode;
	private String[]	aryRTName;
	private String[]	aryHoliday;
	private String[] 	aryDay1;
	private String[] 	aryDay2;
	private String[] 	aryDay3;
	private String[] 	aryDay4;
	private String[] 	aryDay5;
	private String[] 	aryDay6;
	private String[] 	aryDay7;
	private String[] 	aryDay8;
	private String[] 	aryDay9;
	private String[] 	aryDay10;

	private String 	txtRTCode;
	private String 	txtRTName;

	//v_EXg
	public String[][] aryPltWorkType;
	public String[][] aryPltHoliday;

	//tB[hyѐ
	public static final String NAM_RT_CODE    	= CommonConst.NAM_COMMON_CODE;
	public static final String NAM_RT_NAME    	= CommonConst.NAM_COMMON_MEISYO;
	public static final String NAM_HOLIDAY   		= CommonConst.NAM_PUBLIC_HOLIDAY;
	public static final String NAM_DAY1  			= CommonConst.NAM_DAY1;
	public static final String NAM_DAY2 			= CommonConst.NAM_DAY2;
	public static final String NAM_DAY3    		= CommonConst.NAM_DAY3;
	public static final String NAM_DAY4    		= CommonConst.NAM_DAY4;
	public static final String NAM_DAY5   		= CommonConst.NAM_DAY5;
	public static final String NAM_DAY6  			= CommonConst.NAM_DAY6;
	public static final String NAM_DAY7 			= CommonConst.NAM_DAY7;
	public static final String NAM_DAY8    		= CommonConst.NAM_DAY8;
	public static final String NAM_DAY9    		= CommonConst.NAM_DAY9;
	public static final String NAM_DAY10   		= CommonConst.NAM_DAY10;

	public static final int	LEN_RT_CODE 	= 10;
	public static final int	LEN_RT_NAME		= 25;

	//\[gL[	
	public final String KEY_RT_CODE	= "keyRtCode";
	public final String KEY_RT_NAME	= "keyRtName";

	// [h(0FȂA1F)
	private int searchmode;

	/**
	 * RXgN^
	 */
	public ScheduleRotationListVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		txtRTCode	= "";
		txtRTName	= "";

		aryRTCode   = new String[0];
		aryRTName   = new String[0];
		aryHoliday  = new String[0];
		aryDay1     = new String[0];
		aryDay2  	= new String[0];
		aryDay3     = new String[0];
		aryDay4     = new String[0];
		aryDay5    	= new String[0];
		aryDay6     = new String[0];
		aryDay7     = new String[0];
		aryDay8  	= new String[0];
		aryDay9     = new String[0];
		aryDay10    = new String[0];
		setFormerKey(KEY_RT_CODE);
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		txtRTCode	= request.getParameter(PRM_TXT_RT_CODE);
		txtRTName   = request.getParameter(PRM_TXT_RT_NAME);
	}

	/**
	 * tB[hݒ
	 * @param listRotationTable ֔ԃp^[Xg
	 */
	public void setFields(List listRotationTable) {
		//Xg̐ݒ
		list = listRotationTable;
		//f[^̎擾
		count = listRotationTable.size();
		//z̏
		aryRTCode 	= new String[count];
		aryRTName 	= new String[count];
		aryHoliday	= new String[count];
		aryDay1 	= new String[count];
		aryDay2 	= new String[count];
		aryDay3 	= new String[count];
		aryDay4 	= new String[count];
		aryDay5 	= new String[count];
		aryDay6 	= new String[count];
		aryDay7 	= new String[count];
		aryDay8 	= new String[count];
		aryDay9 	= new String[count];
		aryDay10 	= new String[count];
		//f[^̐ݒ
		int i = 0;
		Iterator it = listRotationTable.iterator();
		while (it.hasNext()) {
			CmRotationDto dto	= (CmRotationDto)it.next();
			aryRTCode[i]       	= escapeHTML(dto.getRtCode());
			aryRTName[i]     	= escapeHTML(dto.getRtName());

			aryHoliday[i] = "";
			for (int j = 0; j < aryPltHoliday.length; j++) {
				if (aryPltHoliday[j][0].equals(String.valueOf(dto.getHolidayFlag()))) {
					aryHoliday[i] = aryPltHoliday[j][1];
					break;
				}
			}

			aryDay1[i] 	= "";
			for(int j = 0; j < aryPltWorkType.length; j++) {
				if (aryPltWorkType[j][0].equals(String.valueOf(dto.getDay1()))) {
					aryDay1[i] = aryPltWorkType[j][1];
					break;					                               
				}
			}
			aryDay2[i] 	= "";
			for(int j = 0; j < aryPltWorkType.length; j++) {
				if (aryPltWorkType[j][0].equals(String.valueOf(dto.getDay2()))) {
					aryDay2[i] = aryPltWorkType[j][1];
					break;					                               
				}
			}
			aryDay3[i] 	= "";
			for(int j = 0; j < aryPltWorkType.length; j++) {
				if (aryPltWorkType[j][0].equals(String.valueOf(dto.getDay3()))) {
					aryDay3[i] = aryPltWorkType[j][1];
					break;					                               
				}
			}
			aryDay4[i] 	= "";
			for(int j = 0; j < aryPltWorkType.length; j++) {
				if (aryPltWorkType[j][0].equals(String.valueOf(dto.getDay4()))) {
					aryDay4[i] = aryPltWorkType[j][1];
					break;					                               
				}
			}
			aryDay5[i] 	= "";
			for(int j = 0; j < aryPltWorkType.length; j++) {
				if (aryPltWorkType[j][0].equals(String.valueOf(dto.getDay5()))) {
					aryDay5[i] = aryPltWorkType[j][1];
					break;					                               
				}
			}
			aryDay6[i] 	= "";
			for(int j = 0; j < aryPltWorkType.length; j++) {
				if (aryPltWorkType[j][0].equals(String.valueOf(dto.getDay6()))) {
					aryDay6[i] = aryPltWorkType[j][1];
					break;					                               
				}
			}
			aryDay7[i] 	= "";
			for(int j = 0; j < aryPltWorkType.length; j++) {
				if (aryPltWorkType[j][0].equals(String.valueOf(dto.getDay7()))) {
					aryDay7[i] = aryPltWorkType[j][1];
					break;					                               
				}
			}
			aryDay8[i] 	= "";
			for(int j = 0; j < aryPltWorkType.length; j++) {
				if (aryPltWorkType[j][0].equals(String.valueOf(dto.getDay8()))) {
					aryDay8[i] = aryPltWorkType[j][1];
					break;					                               
				}
			}
			aryDay9[i] 	= "";
			for(int j = 0; j < aryPltWorkType.length; j++) {
				if (aryPltWorkType[j][0].equals(String.valueOf(dto.getDay9()))) {
					aryDay9[i] = aryPltWorkType[j][1];
					break;					                               
				}
			}
			aryDay10[i] 	= "";
			for(int j = 0; j < aryPltWorkType.length; j++) {
				if (aryPltWorkType[j][0].equals(String.valueOf(dto.getDay10()))) {
					aryDay10[i] = aryPltWorkType[j][1];
					break;					                               
				}
			}
			i++;
		}
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	//ANZT\bh
	public String[] getEscAryRTCode		() { return aryRTCode.clone(); 	}
	public String[] getEscAryRTName		() { return aryRTName.clone(); 	}
	public String[] getEscAryHoliday	() { return aryHoliday.clone();	}
	public String[] getEscAryDay1    	() { return aryDay1.clone(); 	}
	public String[] getEscAryDay2		() { return aryDay2.clone(); 	}
	public String[] getEscAryDay3    	() { return aryDay3.clone(); 	}
	public String[] getEscAryDay4		() { return aryDay4.clone(); 	}
	public String[] getEscAryDay5   	() { return aryDay5.clone(); 	}
	public String[] getEscAryDay6		() { return aryDay6.clone(); 	}
	public String[] getEscAryDay7    	() { return aryDay7.clone(); 	}
	public String[] getEscAryDay8		() { return aryDay8.clone(); 	}
	public String[] getEscAryDay9    	() { return aryDay9.clone(); 	}
	public String[] getEscAryDay10		() { return aryDay10.clone();	}	

	public String getTxtRTCode     () { return txtRTCode; }
	public String getTxtRTName     () { return txtRTName; }

	public String getEscTxtRTCode	() { return escapeHTML(txtRTCode); }
	public String getEscTxtRTName	() { return escapeHTML(txtRTName); }

	public void setTxtRTCode	(String txtRTCode)		{ this.txtRTCode	= txtRTCode; }
	public void setTxtRTName	(String txtRTName)	 	{ this.txtRTName 	= txtRTName; }

	public void setSearchmode(int searchmode) { this.searchmode = searchmode; }
	public int getSearchmode() { return searchmode; }

}
